/****** OBJECT:  STOREDPROCEDURE [DBO].[P_CG_FND_VERBA_FECHAMENTO_CONTRATO]    SCRIPT DATE: 04/08/2014 09:57:57 ******/
IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_CG_FND_VERBA_FECHAMENTO_CONTRATO]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [DBO].[P_CG_FND_VERBA_FECHAMENTO_CONTRATO]
GO
--P_CG_FND_VERBA_FECHAMENTO_CONTRATO 1,2
CREATE PROCEDURE P_CG_FND_VERBA_FECHAMENTO_CONTRATO(@CD_EMP INT, @CD_FND_VERBA INT)
AS
begin
SET NOCOUNT ON 

CREATE TABLE #RsDocumentos (
					   CD_EMP INT,
					   CD_FILIAL INT,
					   CD_DOCUMENTO INT,
					   CD_DOCUMENTO_CONTROLE INT,
					   VLR_PROD_VERBA MONEY)

DECLARE @CD_FORN INT
DECLARE @TP_CONTRATO INT
DECLARE @CD_FND_VERBA_FECHAMENTO INT
DECLARE @CD_HIST INT
DECLARE @VLR_FECH MONEY

SELECT
	@CD_FORN = CD_FORN,
	@TP_CONTRATO = TP_LANC
FROM
	CG_FND_VERBA
WHERE
	CD_EMP = @CD_EMP
	AND CD_FND_VERBA = @CD_FND_VERBA

IF @TP_CONTRATO = 1
BEGIN
	INSERT INTO 
		#RsDocumentos
	SELECT
		IT.CD_EMP,
		IT.CD_FILIAL,
		IT.CD_VD,
		IT.CD_IT,
		IT.VLR_PROD_VERBA
	FROM
		CG_FND_VERBA_GERACAO_PDV_VD_IT IT

		LEFT JOIN CG_FND_VERBA_FECHAMENTO_CG_FND_VERBA_GERACAO_PDV_VD_IT VINC ON
			IT.CD_EMP = VINC.CD_EMP
			AND IT.CD_FILIAL = VINC.CD_FILIAL
			AND IT.CD_VD = VINC.CD_VD
			AND IT.CD_IT = VINC.CD_IT
			AND IT.CD_FND_VERBA = VINC.CD_FND_VERBA

	WHERE
		IT.CD_FND_VERBA = @CD_FND_VERBA
		AND VINC.CD_EMP IS NULL
END 


IF @TP_CONTRATO = 2
BEGIN
	INSERT INTO 
		#RsDocumentos
	SELECT
		IT.CD_EMP,
		IT.CD_FILIAL,
		IT.CD_NF,
		IT.CD_PROD,
		IT.VLR_PROD_VERBA
	FROM
		CG_FND_VERBA_GERACAO_EST_NF_ENT_IT IT
		LEFT JOIN CG_FND_VERBA_FECHAMENTO_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT  VINC ON
			IT.CD_EMP = VINC.CD_EMP
			AND IT.CD_FILIAL = VINC.CD_FILIAL
			AND IT.CD_NF = VINC.CD_NF
			AND IT.CD_PROD = VINC.CD_PROD
			AND IT.CD_FND_VERBA = VINC.CD_FND_VERBA
	WHERE
		IT.CD_FND_VERBA = @CD_FND_VERBA
		AND VINC.CD_EMP IS NULL
END
	


IF EXISTS (SELECT * FROM #RsDocumentos)
BEGIN
	
	BEGIN TRY
		
		BEGIN TRAN;

		SELECT @VLR_FECH = SUM(VLR_PROD_VERBA) FROM #RsDocumentos

		SELECT @CD_FND_VERBA_FECHAMENTO = COALESCE(MAX(CD_FND_VERBA_FECHAMENTO),0) + 1 FROM CG_FND_VERBA_FECHAMENTO

		INSERT INTO
			CG_FND_VERBA_FECHAMENTO (CD_FND_VERBA_FECHAMENTO, CD_EMP, CD_FND_VERBA, VLR_FND_VERBA_FECHAMENTO, DT_CAD, CD_USU, DT_FECHAMENTO, TP_LANC)
		VALUES
			(@CD_FND_VERBA_FECHAMENTO, @CD_EMP, @CD_FND_VERBA, @VLR_FECH, CONVERT(DATE, GETDATE()), 1, GETDATE(), @TP_CONTRATO)

	END TRY

	BEGIN CATCH
		RAISERROR ('P_CG_FND_VERBA_FECHAMENTO_CONTRATO - ERRO AO REALIZAR FECHAMENTO.', 16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	END CATCH

		--***************GERANDO O CONTAS A RECEBER***************--
		--AQUI NÃO TEM TRY PORQUE EXISTE UM TRY DENTRO DA ROTINA
		EXEC P_CG_FND_VERBA_FECHAMENTO_CONTRATO_CONTAS_RECEBER @CD_EMP, @CD_FND_VERBA, @VLR_FECH


	BEGIN TRY
		SELECT @CD_HIST = COALESCE(MAX(CD_HIST),0) + 1 FROM CG_FND_VERBA_HIST

		INSERT INTO
			CG_FND_VERBA_HIST (CD_HIST, CD_EMP, CD_FND_VERBA, TP_HIST, DS_HIST, CD_USU, DT_HIST, HR_HIST)
		VALUES
			(@CD_HIST, @CD_EMP, @CD_FND_VERBA, 'FECHAMENTO', 'FECHAMENTO', 1, GETDATE(), GETDATE())


		IF @TP_CONTRATO = 1
		BEGIN
			INSERT INTO
				CG_FND_VERBA_FECHAMENTO_CG_FND_VERBA_GERACAO_PDV_VD_IT (CD_FND_VERBA_FECHAMENTO, CD_EMP, CD_FND_VERBA, CD_FILIAL, CD_VD, CD_IT)
			SELECT
				@CD_FND_VERBA_FECHAMENTO,
				CD_EMP,
				@CD_FND_VERBA,
				CD_FILIAL,
				CD_DOCUMENTO,
				CD_DOCUMENTO_CONTROLE
			FROM
				#RsDocumentos
		END


		IF @TP_CONTRATO = 2
		BEGIN
			INSERT INTO
				CG_FND_VERBA_FECHAMENTO_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT (CD_FND_VERBA_FECHAMENTO, CD_EMP, CD_FND_VERBA, CD_FILIAL, CD_NF, CD_PROD)
			SELECT
				@CD_FND_VERBA_FECHAMENTO,
				CD_EMP,
				@CD_FND_VERBA,
				CD_FILIAL,
				CD_DOCUMENTO,
				CD_DOCUMENTO_CONTROLE
			FROM
				#RsDocumentos
		END

		COMMIT;
	END TRY

	BEGIN CATCH
		RAISERROR ('P_CG_FND_VERBA_FECHAMENTO_CONTRATO - ERRO AO REALIZAR FECHAMENTO.', 16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	END CATCH
	
END

DROP TABLE #RsDocumentos
RETURN

END
